/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.step.core.attachments;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWException;
import filenet.vw.idm.toolkit.IVWIDMAttachment;
import filenet.vw.idm.toolkit.IVWIDMDocAttachment;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.VWAttachmentSelectionHelper;
import filenet.vw.toolkit.utils.VWStringUtils;

public class VWAttachmentHelper {
    private IVWIDMItem m_idmToolkitItem = null;
    private VWAttachment m_vwAttachment = null;

    public VWAttachmentHelper(VWAttachment vwAttachment) {
        this.m_vwAttachment = vwAttachment;
    }

    public boolean canView() throws Exception {
        IVWIDMDocument idmDocument = this.getIDMDocument();
        return idmDocument != null && idmDocument.canView();
    }

    public boolean canOpen() throws Exception {
        IVWIDMDocument idmDocument = this.getIDMDocument();
        return idmDocument != null && idmDocument.canOpen();
    }

    public boolean canCheckin() throws Exception {
        IVWIDMDocument idmDocument = this.getIDMDocument();
        return idmDocument != null && idmDocument.canCheckin();
    }

    public boolean canCheckout() throws Exception {
        IVWIDMDocument idmDocument = this.getIDMDocument();
        return idmDocument != null && idmDocument.canCheckout();
    }

    public boolean canCancelCheckout() throws Exception {
        IVWIDMDocument idmDocument = this.getIDMDocument();
        return idmDocument != null && idmDocument.canCancelCheckout();
    }

    public boolean isDocument() throws Exception {
        IVWIDMDocument idmDocument = this.getIDMDocument();
        return idmDocument != null;
    }

    public boolean isISItem() throws Exception {
        IVWIDMDocument idmDocument = this.getIDMDocument();
        return this.m_idmToolkitItem != null && this.m_idmToolkitItem.getLibraryType() == 1;
    }

    public boolean isCheckedOut() throws Exception {
        IVWIDMDocument idmDocument;
        if (this.m_vwAttachment != null && this.m_vwAttachment.getType() == 3 && (idmDocument = this.getIDMDocument()) != null) {
            return idmDocument.isCheckedOut();
        }
        return false;
    }

    public void updateCheckoutStatus() throws Exception {
        if (this.m_vwAttachment != null && this.m_vwAttachment.getType() == 3) {
            if (this.m_idmToolkitItem == null) {
                this.getIDMDocument();
            } else {
                this.m_idmToolkitItem.refresh();
            }
        }
    }

    public void view() throws Exception {
        IVWIDMAttachment idmAttachment = this.getIDMAttachment();
        if (idmAttachment != null && idmAttachment instanceof IVWIDMDocAttachment) {
            ((IVWIDMDocAttachment)idmAttachment).view();
        }
    }

    public void open() throws Exception {
        if (this.m_vwAttachment != null && this.m_vwAttachment.getType() == 5) {
            VWAttachmentSelectionHelper.openURL(this.m_vwAttachment.getId());
        } else {
            IVWIDMAttachment idmAttachment = this.getIDMAttachment();
            if (idmAttachment != null) {
                switch (this.m_idmToolkitItem.getType()) {
                    case 3: {
                        if (this.canOpen()) {
                            idmAttachment.open();
                            break;
                        }
                        throw new VWException("vw.toolkit.runtime.step.core.attachments.insufficentRightsToOpen", "You have insufficent rights to open the document.");
                    }
                    case 2: 
                    case 4: {
                        idmAttachment.open();
                    }
                }
            }
        }
    }

    public void checkout() throws Exception {
        IVWIDMAttachment idmAttachment = this.getIDMAttachment();
        if (idmAttachment != null && idmAttachment instanceof IVWIDMDocAttachment) {
            ((IVWIDMDocAttachment)idmAttachment).checkout();
        }
    }

    public void checkoutAndOpen() throws Exception {
        IVWIDMAttachment idmAttachment = this.getIDMAttachment();
        if (idmAttachment != null && idmAttachment instanceof IVWIDMDocAttachment) {
            ((IVWIDMDocAttachment)idmAttachment).checkoutAndOpen();
        }
    }

    public void checkin() throws Exception {
        IVWIDMAttachment idmAttachment = this.getIDMAttachment();
        if (idmAttachment != null && idmAttachment instanceof IVWIDMDocAttachment) {
            ((IVWIDMDocAttachment)idmAttachment).checkin();
        }
    }

    public void cancelCheckout() throws Exception {
        IVWIDMAttachment idmAttachment = this.getIDMAttachment();
        if (idmAttachment != null && idmAttachment instanceof IVWIDMDocAttachment) {
            ((IVWIDMDocAttachment)idmAttachment).cancelCheckout();
        }
    }

    public void showVersionListWindow() throws Exception {
        IVWIDMAttachment idmAttachment = this.getIDMAttachment();
        if (idmAttachment != null && idmAttachment instanceof IVWIDMDocAttachment) {
            ((IVWIDMDocAttachment)idmAttachment).showVersionListWindow();
        }
    }

    public void showPropertiesDialog() throws Exception {
        IVWIDMAttachment idmAttachment = this.getIDMAttachment();
        if (idmAttachment != null) {
            idmAttachment.showPropertiesDialog();
        }
    }

    protected boolean hasNameChanged() throws Exception {
        String idmName;
        String originalName;
        if (this.m_vwAttachment != null && this.m_idmToolkitItem != null && VWStringUtils.compare(originalName = this.m_vwAttachment.getAttachmentName(), idmName = this.m_idmToolkitItem.getLabel()) != 0) {
            this.m_vwAttachment.setAttachmentName(idmName);
            return true;
        }
        return false;
    }

    private IVWIDMAttachment getIDMAttachment() throws Exception {
        if (this.m_vwAttachment != null) {
            switch (this.m_vwAttachment.getType()) {
                case 0: 
                case 5: {
                    return null;
                }
            }
            if (this.m_idmToolkitItem == null) {
                this.m_idmToolkitItem = VWIDMBaseFactory.instance().getIDMItemFromVWAttachment(this.m_vwAttachment);
            }
            if (this.m_idmToolkitItem != null) {
                return this.m_idmToolkitItem.getAttachment();
            }
            throw new VWException("vw.toolkit.runtime.step.core.attachments.attachedItemUnavailable", "The attached item is unavailable.");
        }
        return null;
    }

    private IVWIDMDocument getIDMDocument() throws Exception {
        this.getIDMAttachment();
        if (this.m_idmToolkitItem != null && this.m_idmToolkitItem instanceof IVWIDMDocument) {
            return (IVWIDMDocument)this.m_idmToolkitItem;
        }
        return null;
    }
}

